﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Net;
using System.Text;
using System.Windows.Forms;

namespace OpenAPI_App_Manager
{
    public partial class frmSearchSettings : Form
    {
        private OpenAPI_App_Manager.AppSettings.SearchSettings settings;
        public OpenAPI_App_Manager.AppSettings.SearchSettings Settings
        {
            get
            {
                return this.settings;
            }
        }

        public frmSearchSettings(OpenAPI_App_Manager.AppSettings.SearchSettings Settings)
        {
            InitializeComponent();

            this.settings = Settings;
            textBoxCommunity.Text = settings.SNMPv1Community;
            textBoxContext.Text = settings.SNMPv3Context;
            if (settings.SNMPVersion == 3)
                radioButtonSNMPv3.Checked = true;
            else
                radioButtonSNMPv1.Checked = true;
            if (settings.SearchMethod == "SNMPBroadcast")
                radioButtonSNMPBroadcast.Checked = true;
            else if (settings.SearchMethod == "SNMPPing")
                radioButtonSNMPPing.Checked = true;
            else
                radioButtonUPnP.Checked = true;

            ipInputBroadcast.Text = settings.SNMPBroadcastAddress;
            ipInputEndAddress.Text = settings.SNMPPingEndAddress;
            ipInputStartAddress.Text = settings.SNMPPingStartAddress;
        }

        private void radioButtonsSearchSettings_CheckedChanged(object sender, EventArgs e)
        {
            labelStartAddress.Visible = radioButtonSNMPPing.Checked;
            ipInputStartAddress.Visible = radioButtonSNMPPing.Checked;
            labelEndAddress.Visible = radioButtonSNMPPing.Checked;
            ipInputEndAddress.Visible = radioButtonSNMPPing.Checked;
            labelBroadcast.Visible = radioButtonSNMPBroadcast.Checked;
            ipInputBroadcast.Visible = radioButtonSNMPBroadcast.Checked;

            panelSNMPVer.Visible = (!radioButtonUPnP.Checked);
            labelCommunity.Visible = (radioButtonSNMPv1.Checked && !radioButtonUPnP.Checked);
            textBoxCommunity.Visible = (radioButtonSNMPv1.Checked && !radioButtonUPnP.Checked);
            labelContext.Visible = (radioButtonSNMPv3.Checked && !radioButtonUPnP.Checked);
            textBoxContext.Visible = (radioButtonSNMPv3.Checked && !radioButtonUPnP.Checked);
            labelUsername.Visible = (radioButtonSNMPv3.Checked && !radioButtonUPnP.Checked);
            textBoxUsername.Visible = (radioButtonSNMPv3.Checked && !radioButtonUPnP.Checked);
        }

        private void radioButtonSNMPv1_CheckedChanged(object sender, EventArgs e)
        {
            if (!radioButtonUPnP.Checked)
            {
                labelCommunity.Visible = radioButtonSNMPv1.Checked;
                textBoxCommunity.Visible = radioButtonSNMPv1.Checked;
                labelContext.Visible = radioButtonSNMPv3.Checked;
                textBoxContext.Visible = radioButtonSNMPv3.Checked;
                labelUsername.Visible = radioButtonSNMPv3.Checked;
                textBoxUsername.Visible = radioButtonSNMPv3.Checked;
            }
        }

        private string MakeValidIP(string Address)
        {
            string szNew = string.Empty;
            foreach (char c in Address)
                if (char.IsDigit(c) || c == '.')
                    szNew += c;

            List<int> lOctets = new List<int>();
            int iStartOfOctet = 0;
            for (int i = 0; i < szNew.Length; i++)
            {
                if (szNew[i] == '.')
                {
                    if (szNew[i - 1] == '.')
                        continue;

                    lOctets.Add(int.Parse(szNew.Substring(iStartOfOctet, i - iStartOfOctet)));
                    iStartOfOctet = i + 1;
                }
            }
            if (szNew != string.Empty && !szNew.EndsWith("."))
                lOctets.Add(int.Parse(szNew.Substring(szNew.LastIndexOf(".") + 1)));

            List<int> lOctetsBetter = new List<int>();
            int iCount = 0;
            foreach (int iOctet in lOctets)
            {
                int iNewOctet = iOctet;

                iCount++;
                if (iNewOctet > 255) iNewOctet = 255;
                lOctetsBetter.Add(iNewOctet);
                if (iCount == 4)
                    break;
            }

            while (lOctetsBetter.Count < 4)
                lOctetsBetter.Add(0);

            if (lOctetsBetter[0] == 0)
                lOctetsBetter[0] = 1;

            szNew = string.Empty;
            foreach (int iOctet in lOctetsBetter)
                szNew += iOctet.ToString() + ".";

            //Remove final "."
            szNew = szNew.Substring(0, szNew.Length - 1);

            return szNew;
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            settings.SNMPBroadcastAddress = MakeValidIP(ipInputBroadcast.Text);
            settings.SNMPPingStartAddress = MakeValidIP(ipInputStartAddress.Text);
            settings.SNMPPingEndAddress = MakeValidIP(ipInputEndAddress.Text);
            settings.SNMPv1Community = textBoxCommunity.Text;
            settings.SNMPv3Context = textBoxContext.Text;
            settings.SNMPv3Username = textBoxUsername.Text;
            if (radioButtonSNMPv1.Checked)
                settings.SNMPVersion = 1;
            else if (radioButtonSNMPv3.Checked)
                settings.SNMPVersion = 3;
            if (radioButtonUPnP.Checked)
                settings.SearchMethod = "UPnP";
            else if (radioButtonSNMPPing.Checked)
                settings.SearchMethod = "SNMPPing";
            else if (radioButtonSNMPBroadcast.Checked)
                settings.SearchMethod = "SNMPBroadcast";
        }
    }
}
